#include <iostream>
#include <vector>
#include <set>
#include <map>
#include <string>
#include <algorithm>
using namespace std;
template <class T>
ostream& operator<<(ostream& cout, const vector<T>& vec)
{
	for (const T& t : vec)
		cout << t << " ";
	return cout << "\n";
}
template <class T1, class T2>
ostream& operator<<(ostream& cout, const pair<T1, T2>& p)
{
	return cout << p.first << " " << p.second << "\n";
}
#define For(i, n) for(int i = 0; i < n; ++i)
#define For3(i, s, n) for(int i = s; i < n; ++i)
#define For4(i, s, n, c) for(int i = s; i < n == c > 0; i += c)
#define all(i) i.begin(), i.end()
#define int long long
const int INF = 1e9 + 17;
const int MOD = 1e9 + 7;
const int N = 1e6 + 7;
struct MVec
{
	double x = 0, y = 0;
	MVec(double x = 0, double y = 0) : x(x), y(y)
	{

	}

	friend MVec operator+(const MVec& v1, const MVec& v2)
	{
		return MVec(v1.x + v2.x, v1.y + v2.y);
	}
	friend MVec& operator+=(MVec& v1, const MVec& v2)
	{
		v1.x += v2.x;
		v1.y += v2.y;
		return v1;
	}
	friend MVec operator-(const MVec& v1, const MVec& v2)
	{
		return MVec(v1.x - v2.x, v1.y - v2.y);
	}
	friend MVec& operator-=(MVec& v1, const MVec& v2)
	{
		v1.x -= v2.x;
		v1.y -= v2.y;
		return v1;
	}

	friend MVec operator*(const MVec& v1, const MVec& v2)
	{

	}
};
struct Ver
{
	int val = 0, add = 0;
	int l, r;

	void inc(int dx)
	{
		add += dx;
		val += dx * (r - l);
	}
};
struct SegmentTree
{
	vector<Ver> vec;
	int n;

	void resize(int nn)
	{
		n = 1;
		while (n < nn) n *= 2;

		vec.resize(n);

		For(i, n)
		{
			vec[i + n].l = i;
			vec[i + n].r = i + 1;
		}
		For4(i, n - 1, 1, -1)
		{
			vec[i].l = vec[i * 2].l;
			vec[i].r = vec[i * 2 + 1].r;
		}
	}
	void update(int i)
	{
		if (i >= n) return;
		vec[i].val = vec[i * 2].val + vec[i * 2 + 1].val;
	}
	void push(int i)
	{
		if (i >= n) return;
		vec[i * 2].inc(vec[i].add);
		vec[i * 2 + 1].inc(vec[i].add);
		vec[i].add = 0;
	}

	void inc(int l, int r, int dx, int i = 1)
	{
		push(i);
		if (r <= vec[i].l || vec[i].r <= l) return;
		if (l <= vec[i].l && vec[i].r <= r)
		{
			vec[i].inc(dx);
			return;
		}
		inc(l, r, dx, i * 2);
		inc(l, r, dx, i * 2 + 1);
		update(i);
	}

	int gt(int l, int r, int i = 1)
	{
		push(i);
		if (r <= vec[i].l || vec[i].r <= l) return 0;
		if (l <= vec[i].l && vec[i].r <= r) return vec[i].val;
		return gt(l, r, i * 2) + gt(l, r, i * 2 + 1);
	}
};
#define DL(x, y) (((x) + (y) - 1) / (y))




vector<int> g[N];
int used[N];
int nowUsed = 1;
vector<int> toL;
int n, m, t;


bool DFS(int v)
{
	if (used[v] == nowUsed) return false;
	used[v] = nowUsed;

	for (int u : g[v])
	{
		if (toL[u] == -1)
		{
			toL[u] = v;
			return true;
		}
	}

	for (int u : g[v])
	{
		if (DFS(toL[u]))
		{
			toL[u] = v;
			return true;
		}
	}

	return false;
}

void solve()
{
	int w0, h0, w, h, x, y;
	cin >> w0 >> h0 >> w >> h >> x >> y;

	int cx1 = DL(x, w);
	int cx2 = DL(w0 - x, w);
	int cy1 = DL(y, h);
	int cy2 = DL(h0 - y, h);

	cout << (cx1 + cx2) * (cy1 + cy2) - 1 << "\n";
}

signed main()
{
	//////////
	{
	ios_base::sync_with_stdio(0);
	cin.tie(0);
	cout.tie(0);
	}
	//////////
	
	cin >> t;
	For(i, t)
	{
		solve();
	}
}
